{DelphiSim                                   }
{v.1.05                                      }
{Roeland van der Spek                        }
{spekw@acm.org                               }
{(C) 1997                                    }
{Example: creation of a few simple processes }

unit Examp1;

interface

uses
  Windows, Messages,SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, delphiSim, Random;

type
  TForm1 = class(TForm)
    Simulation1: TSimulation;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Simulation1SimEnd;
    procedure Simulation1SimInit(eventlist: TEventList);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  {Define a new process type. Be sure to override the body
   method. It should contain the simulation code for the
   process}

  TMyProcess = class(TSimProcess) {define a new process}
    procedure body; override;     {define its body }
  end;

var
  Form1: TForm1;
  MyStream:TRandomStream; {A randomstream is assigned here}

implementation

{The process that we have defined will perform an endless cycle until
 the replication length has been exceeded. In this cycle the process
 will hold for an exponentially distributed time with mean 2 and then
 continue}

Procedure TMyProcess.body;    {the description of what the process does}
begin
  while not false do
    holdfor(drawExpo(2,MyStream));
end;


{$R *.DFM}

{The simulation is started with a click on the button, but before
 the simulation is actually started we will initialize the random
 number stream and disable the button. This button will be re- enabled
 when the simulation terminates}

procedure TForm1.Button1Click(Sender: TObject);
begin
  MyStream:=TRandomStream.create(133,245);  {create a randomStream}
  button1.enabled:=false;
  Simulation1.startSimulation;
end;

{handler for the SimEnd event. The button is re-enabled}

procedure TForm1.Simulation1SimEnd;
begin
  button1.enabled:=true;
end;

{The siminit Event is used to initialize all the processes
 that will run during the simulation. This is done by creating them.
 In this case we will define four identical processes of type
 MyProcess, each scheduled to start at a different time}

procedure TForm1.Simulation1SimInit(eventlist: TEventList);
begin
  TMyProcess.create(Simulation1,0,'process 1');
  TMyProcess.create(Simulation1,0,'process 2');
  TMyProcess.create(Simulation1,5,'process 3');
  TMyProcess.create(Simulation1,10,'process 4');
end;

end.
